library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;
use ieee.std_logic_textio.all;

entity fir_tb is

end fir_tb;

architecture generated of fir_tb is

  constant NumPhases : positive := 1;
  constant WIn : positive := 5;
  constant WOut : positive := 10;

  constant infile : string := "fir_in.stim";
  constant outfile : string := "fir_out.stim";

  constant period : time := 20 ns;

  type x_array is array (0 to NumPhases-1) of std_logic_vector(WIn-1 downto 0);

  component fir
    port (
      clk, reset : in  std_logic;
      x_0        : in  std_logic_vector(WIn-1 downto 0);
      y          : out std_logic_vector(WOut-1 downto 0));
  end component;

  component firref
    port (
      clk, reset : in  std_logic;
      x_0        : in  std_logic_vector(WIn-1 downto 0);
      y          : out std_logic_vector(WOut-1 downto 0));
  end component;

  signal clk : std_logic := '0';
  signal reset : std_logic := '1';

  signal x : x_array;
  signal y : std_logic_vector(WOut-1 downto 0);
  signal yref : std_logic_vector(WOut-1 downto 0);
  signal ytrue : std_logic_vector(WOut-1 downto 0);
  signal check : std_logic;
  signal checkref : std_logic;

begin  -- test

  reset <= '0', '1' after period;
  clk <= not clk after period/2;

  tester: process
    variable l : line;
    file datain : text open read_mode is infile;
    file dataout : text open read_mode is outfile;

    variable x_v : x_array;
    variable y_v : std_logic_vector(WOut-1 downto 0);

  begin

    wait until reset = '1';

    loop
      readline(datain, l);
      for i in 0 to NumPhases-1 loop
        read(l, x_v(i));
      end loop;  -- i
      x <= x_v;

      readline(dataout, l);
      read(l, y_v);
      ytrue <= y_v;

      wait until rising_edge(clk);

    end loop;

  end process tester;

  DUT: fir
    port map (
      clk   => clk,
      reset => reset,
      x_0   => x(0),
      y     => y);

  DUTref: firref
    port map (
      clk   => clk,
      reset => reset,
      x_0   => x(0),
      y     => yref);

  process(clk, reset)
  begin
    if reset = '0' then
      check <= '0';
    elsif clk'event and clk = '1' then
      if y = ytrue then
        check <= '0';
      else
        check <= '1';
      end if;
    end if;
  end process;

  process(clk, reset)
  begin
    if reset = '0' then
      checkref <= '0';
    elsif clk'event and clk = '1' then
      if yref = ytrue then
        checkref <= '0';
      else
        checkref <= '1';
      end if;
    end if;
  end process;

end generated;
